package ch.frankel.blog.spring.authoring.ehcache;

import java.util.ArrayList;
import java.util.List;

import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cache.ehcache.EhCacheFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * Bean definition parser for EhCache simple definition.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
public class EhCacheBeanDefinitionParser extends AbstractSimpleBeanDefinitionParser {

    private static final List<String> PROP_TAG_NAMES;

    static {

        PROP_TAG_NAMES = new ArrayList<String>();

        PROP_TAG_NAMES.add("eternal");
        PROP_TAG_NAMES.add("cacheName");
        PROP_TAG_NAMES.add("maxElementsInMemory");
        PROP_TAG_NAMES.add("maxElementsOnDisk");
        PROP_TAG_NAMES.add("overflowToDisk");
        PROP_TAG_NAMES.add("diskExpiryThreadIntervalSeconds");
        PROP_TAG_NAMES.add("diskPersistent");
        PROP_TAG_NAMES.add("timeToLive");
        PROP_TAG_NAMES.add("timeToIdle");
    }

    /**
     * @see AbstractSingleBeanDefinitionParser#getBeanClass(Element)
     */
    @Override
    protected Class<?> getBeanClass(Element element) {

        return EhCacheFactoryBean.class;
    }

    /**
     * @see AbstractBeanDefinitionParser#shouldGenerateIdAsFallback()
     */
    @Override
    protected boolean shouldGenerateIdAsFallback() {

        return true;
    }

    /**
     * @see AbstractSimpleBeanDefinitionParser#doParse(Element, ParserContext,
     *      BeanDefinitionBuilder)
     */
    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {

        for (String name : PROP_TAG_NAMES) {

            String value = element.getAttribute(name);

            if (StringUtils.hasText(value)) {

                builder.addPropertyValue(name, value);
            }
        }

        NodeList nodes = element.getElementsByTagNameNS("http://blog.frankel.ch/spring/ehcache", "manager");

        if (nodes.getLength() > 0) {

            builder.addPropertyReference("cacheManager", nodes.item(0).getAttributes().getNamedItem("ref")
                    .getNodeValue());
        }

        String msep = element.getAttribute("memoryStoreEvictionPolicy");

        if (StringUtils.hasText(msep)) {

            MemoryStoreEvictionPolicy policy = MemoryStoreEvictionPolicy.fromString(msep);

            builder.addPropertyValue("memoryStoreEvictionPolicy", policy);
        }
    }
}
